// Misc functions module
#include "app.h"

// Standard callbacks for 8/16/24/32 bit color:
static unsigned int HighCol8 (int r,int g,int b,int i)
{
  unsigned int t; (void)i;
  t=(r+g+b)/3;
  return t;
}

static unsigned int HighCol15(int r,int g,int b,int i)
{
  unsigned int t; (void)i;
  t =(r<<7)&0x7c00; // 0rrr rr00 0000 0000
  t|=(g<<2)&0x03e0; // 0000 00gg ggg0 0000
  t|=(b>>3)&0x001f; // 0000 0000 000b bbbb
  return t;
}

static unsigned int HighCol16(int r,int g,int b,int i)
{
  unsigned int t; (void)i;
  t =(r<<8)&0xf800; // rrrr r000 0000 0000
  t|=(g<<3)&0x07e0; // 0000 0ggg ggg0 0000
  t|=(b>>3)&0x001f; // 0000 0000 000b bbbb
  return t;
}

// 24-bit/32-bit
static unsigned int HighCol24(int r,int g,int b,int i)
{
  unsigned int t; (void)i;
  t =(r<<16)&0xff0000;
  t|=(g<<8 )&0x00ff00;
  t|=(b    )&0x0000ff;

  return t;
}

int SetBurnHighCol(int Depth)
{
  if (Depth<= 8) { BurnHighCol=HighCol8;  return 0; }
  if (Depth<=15) { BurnHighCol=HighCol15; return 0; }
  if (Depth<=16) { BurnHighCol=HighCol16; return 0; }
  BurnHighCol=HighCol24;
  return 0;
}

static char *KeyName[]=
{
  // 0x00:
  "","Left Mouse","Right Mouse","Cancel", "Middle Mouse","","","",
  "Backspace","Tab","","", "Clear","Enter", "","",
  // 0x10
  "Shift","Control","Menu","Pause", "Caps Lock","","","",
  "","","","Escape", "","","","",
  // 0x20
  "Space","Page Up","Page Down","End", "Home","Left","Up","Right",
  "Down","","","", "Print Scrn","Insert","Delete","",
  // 0x30
  "0","1","2","3", "4","5","6","7",
  "8","9","","",  "","","","",
  // 0x40
  "", "A","B","C", "D","E","F","G",
  "H","I","J","K", "L","M","N","O",
  // 0x50
  "P","Q","R","S", "T","U","V","W",
  "X","Y","Z","Left Win", "Right Win","App Menu","","",
  // 0x60
  "NumPad 0","NumPad 1","NumPad 2","NumPad 3", "NumPad 4","NumPad 5","NumPad 6","NumPad 7",
  "NumPad 8","NumPad 9","NumPad *","NumPad +", "","NumPad -","NumPad .","NumPad /",
  // 0x70
  "F1","F2","F3","F4", "F5","F6","F7","F8",
  "F9","F10","F11","F12", "","","","",
  // 0x80
  "","","","","","","","", "","","","","","","","",
  // 0x90
  "Num Lock","Scroll Lock"
};

// Print a nice name for input code c
char *InputCodeDesc(int c)
{
  static char String[64];
  char *Name="";
  if (c>=0x4000)
  {
    int Joy=0,Code=0;
    Joy=(c>>8)&0x3f;
    Code=c&0xff;
    if (Code>=0x10)
    {
      sprintf (String,"Joy-%d Button %d",Joy+1,Code-0x0f);
      return String;
    }
    if (Code>=1 && Code<=4)
    {
      static char Dir[4][8]={"Up","Down","Left","Right"};
      sprintf (String,"Joy-%d %s",Joy+1,Dir[Code-1]);
      return String;
    }
  }

  // Try and get a name for the key code
  if (c < sizeof(KeyName)/sizeof(KeyName[0])) Name=KeyName[c]; // Get from the table of first few keys

  if (Name[0]) sprintf (String,"%s",Name);
  else sprintf (String,"Key 0x%.2x",c);
  return String;
}
